<?php
/**
 * Template part for displaying posts in loop
 *
 * @package Case-Themes
 */
$post_address = maxcare()->get_theme_opt( 'post_address', true );
$address_text = maxcare()->get_theme_opt('sg_address_text');

$sg_post_title = maxcare()->get_theme_opt('sg_post_title', 'default');
$sg_post_title_text = maxcare()->get_theme_opt('sg_post_title_text');

$post_social_share = maxcare()->get_theme_opt( 'post_social_share', false );

$bg_img_style = '';
if (has_post_thumbnail()) {
    $bg_url = get_the_post_thumbnail_url(get_the_ID(), 'maxcare-large');
    if ($bg_url) {
        $bg_img_style = 'background-image: url(' . esc_url($bg_url) . ');';
    }
}
?>
<article id="pxl-post-<?php the_ID(); ?>" <?php post_class('pxl---post'); ?>>
    <div class="pxl-post-inner">
        <div id="pxl-inner-post-sg-bg" class="pxl-inner-bg" <?php if ($bg_img_style) echo 'style="' . esc_attr($bg_img_style) . '"'; ?>>
            <a href="<?php the_permalink(); ?>"></a>
        </div>
        <?php maxcare()->blog->get_post_metas(); ?>
        <h2 class="pxl-item--title">
            <a href="<?php the_permalink(); ?>">
                <?php if (is_singular('post') && $sg_post_title == 'custom_text' && !empty($sg_post_title_text)) { ?>
                    <?php echo pxl_print_html($sg_post_title_text); ?>
                <?php } else { ?>
                    <?php the_title(); ?>
                <?php } ?>
            </a>
        </h2>
        <div class="pxl-item--content clearfix">
            <?php
                the_content();
                wp_link_pages( array(
                    'before'      => '<div class="page-links">',
                    'after'       => '</div>',
                    'link_before' => '<span>',
                    'link_after'  => '</span>',
                ) );
            ?>
        </div>
        <?php if( $post_social_share ) :  ?>
            <div class="pxl-inner-social">
                <div class="pxl--post-social">
                    <?php if($post_social_share) { maxcare()->blog->get_socials_share(); } ?>
                </div>
            </div>
        <?php endif; ?>
    </div>
</article><!-- #post -->