<?php

if (!class_exists('maxcare_Blog')) {

    class maxcare_Blog
    {
        
        public function get_archive_meta() {
            $archive_date = maxcare()->get_theme_opt( 'archive_date', true );
            $archive_author = maxcare()->get_theme_opt( 'archive_author', true );
            if($archive_date || $archive_author ) : ?>
                <ul class="pxl-item--meta d-flex-wrap align-items-center">
                    <?php if($archive_author) : ?>
                        <li class="pxl-item--author">
                            <span class="pxl-icon">
                                <i class="fas fa-pencil-alt"></i>
                            </span>
                            <span class="pxl-name">
                                <?php the_author_posts_link(); ?>
                            </span>
                        </li>
                    <?php endif; ?>
                    <?php if($archive_date) : ?>
                        <li class="pxl-item--date pxl-post-list">
                            <span class="pxl-icon">
                                <i class="far fa-calendar-alt"></i>
                            </span>
                            <?php echo get_the_date(); ?>     
                        </li>
                    <?php endif; ?>
                </ul>
            <?php endif; 
        }

        public function get_post_metas(){
            $post_author = maxcare()->get_theme_opt( 'post_author', true );
            $post_comment = maxcare()->get_theme_opt( 'post_comment', true );
            $post_tag = maxcare()->get_theme_opt( 'post_tag', true );
            $post_date = maxcare()->get_theme_opt( 'post_date', true );
            if($post_tag || $post_date || $post_comment || $post_author ) : ?>
                <ul class="pxl-item--meta pxl-flex">
                    <?php 
                    $post_author_id = get_post_field('post_author', get_the_ID());
                    if ( $post_author_id ) : ?>
                        <li class="pxl-item--author">
                            <span class="pxl-icon">
                                <i class="fas fa-pencil-alt"></i>
                            </span>
                            <span class="author-name">
                                <?php echo get_the_author_meta('display_name', $post_author_id); ?>
                            </span>
                        </li>
                    <?php endif; ?>
                    <?php if ($post_tag && get_the_tags()) : ?>
                        <li class="pxl-item--tags pxl-post-list">
                            <span class="pxl-icon">
                                <i class="fas fa-tag"></i>
                            </span>
                            <?php 
                                $tags = get_the_tags();
                                if ($tags) {
                                    $first_tag = $tags[0];
                                    echo '<a href="' . get_tag_link($first_tag->term_id) . '">' . $first_tag->name . '</a>';
                                }
                            ?>
                        </li>
                    <?php endif; ?>
                    <?php if($post_date) : ?>
                        <li class="pxl-item--date pxl-post-list">
                            <span class="pxl-icon">
                                <i class="far fa-calendar-alt"></i>
                            </span>
                            <?php echo get_the_date(); ?>     
                        </li>
                    <?php endif; ?>
                    <?php if($post_comment) : ?>
                        <li class="pxl-comment pxl-post-list">
                            <span class="pxl-icon">
                                <i class="fab fa-rocketchat"></i>
                            </span>
                            <a href="<?php the_permalink(); ?>#comments" class="pxl-item--comment pxl-item--flexnw">
                                <?php echo comments_number(esc_html__('No Comments', 'maxcare'),esc_html__('1 Comment', 'maxcare'),esc_html__('% Comments', 'maxcare')); ?>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            <?php endif; 
        }

        public function get_excerpt(){
            $archive_excerpt_length = maxcare()->get_theme_opt('archive_excerpt_length', '50');
            $maxcare_the_excerpt = get_the_excerpt();
            if(!empty($maxcare_the_excerpt)) {
                echo wp_trim_words( $maxcare_the_excerpt, $archive_excerpt_length, $more = null );
            } else {
                echo wp_kses_post($this->get_excerpt_more( $archive_excerpt_length ));
            }
        }

        public function get_excerpt_more( $post = null ) {
            $archive_excerpt_length = maxcare()->get_theme_opt('archive_excerpt_length', '50');
            $post = get_post( $post );

            if ( empty( $post ) || 0 >= $archive_excerpt_length ) {
                return '';
            }

            if ( post_password_required( $post ) ) {
                return esc_html__( 'Post password required.', 'maxcare' );
            }

            $content = apply_filters( 'the_content', strip_shortcodes( $post->post_content ) );
            $content = str_replace( ']]>', ']]&gt;', $content );

            $excerpt_more = apply_filters( 'maxcare_excerpt_more', '&hellip;' );
            $excerpt      = wp_trim_words( $content, $archive_excerpt_length, $excerpt_more );

            return $excerpt;
        }

        public function maxcare_set_post_views( $postID ) {
            $countKey = 'post_views_count';
            $count    = get_post_meta( $postID, $countKey, true );
            if ( $count == '' ) {
                $count = 0;
                delete_post_meta( $postID, $countKey );
                add_post_meta( $postID, $countKey, '0' );
            } else {
                $count ++;
                update_post_meta( $postID, $countKey, $count );
            }
        }

        public function get_tagged_in(){
            $tags_list = get_the_tag_list( '<label class="label">'.esc_attr__('Tag:', 'maxcare'). '</label>', ' ' );
            if ( $tags_list )
            {
                echo '<div class="pxl--tags pxl-mr-15">';
                printf('%2$s', '', $tags_list);
                echo '</div>';
            }
        }

        public function get_socials_share() { 
            $post_url   = urlencode(get_permalink());
            $post_title = urlencode(get_the_title());
            $img_url    = '';

            if (has_post_thumbnail(get_the_ID())) {
                $thumb = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), 'full');
                if ($thumb) {
                    $img_url = urlencode($thumb[0]);
                }
            }

            $social_facebook  = maxcare()->get_theme_opt('social_facebook', true);
            $social_twitter   = maxcare()->get_theme_opt('social_twitter', true);
            $social_pinterest = maxcare()->get_theme_opt('social_pinterest', true);
            $social_instagram = maxcare()->get_theme_opt('social_instagram', true);
            $social_linkedin  = maxcare()->get_theme_opt('social_linkedin', true);
            ?>
            <div class="pxl--social">
                <div class="pxl-heading-social"><?php echo esc_html__('Share:', 'maxcare'); ?></div>
                
                <?php if ($social_facebook): ?>
                    <a class="fb-social" 
                       title="<?php echo esc_attr__('Facebook', 'maxcare'); ?>" 
                       target="_blank" 
                       href="https://www.facebook.com/sharer/sharer.php?u=<?php echo esc_url($post_url); ?>">
                        <span class="pxl-text-social"><?php echo esc_html__('Facebook', 'maxcare'); ?></span>
                    </a>
                <?php endif; ?>

                <?php if ($social_twitter): ?>
                    <a class="tw-social" 
                       title="<?php echo esc_attr__('Twitter', 'maxcare'); ?>" 
                       target="_blank" 
                       href="https://twitter.com/intent/tweet?url=<?php echo esc_url($post_url); ?>&amp;text=<?php echo esc_attr($post_title); ?>">
                        <span class="pxl-text-social"><?php echo esc_html__('Twitter', 'maxcare'); ?></span>
                    </a>
                <?php endif; ?>

                <?php if ($social_pinterest): ?>
                    <a class="pin-social" 
                       title="<?php echo esc_attr__('Pinterest', 'maxcare'); ?>" 
                       target="_blank" 
                       href="https://pinterest.com/pin/create/button/?url=<?php echo esc_url($post_url); ?>&amp;media=<?php echo esc_url($img_url); ?>&amp;description=<?php echo esc_attr($post_title); ?>">
                        <span class="pxl-text-social"><?php echo esc_html__('Pinterest', 'maxcare'); ?></span>
                    </a>
                <?php endif; ?>

                <?php if ($social_instagram): ?>
                    <a class="ig-social" 
                       title="<?php echo esc_attr__('Instagram', 'maxcare'); ?>" 
                       target="_blank" 
                       href="https://www.instagram.com/">
                        <span class="pxl-text-social"><?php echo esc_html__('Instagram', 'maxcare'); ?></span>
                    </a>
                <?php endif; ?>

                <?php if ($social_linkedin): ?>
                    <a class="lin-social" 
                       title="<?php echo esc_attr__('LinkedIn', 'maxcare'); ?>" 
                       target="_blank" 
                       href="https://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo esc_url($post_url); ?>&amp;title=<?php echo esc_attr($post_title); ?>">
                        <span class="pxl-text-social"><?php echo esc_html__('LinkedIn', 'maxcare'); ?></span>
                    </a>
                <?php endif; ?>

            </div>
            <?php
        }

        public function get_socials_share_portfolio() { 
            $img_url = '';
            if (has_post_thumbnail(get_the_ID()) && wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false)) {
                $img_url = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), false);
            }
            ?>
            <div class="pxl--social">
                <a class="fb-social" title="<?php echo esc_attr__('Facebook', 'maxcare'); ?>" target="_blank" href="http://www.facebook.com/sharer/sharer.php?u=<?php the_permalink(); ?>"><i class="caseicon-facebook"></i></a>
                <a class="tw-social" title="<?php echo esc_attr__('Twitter', 'maxcare'); ?>" target="_blank" href="https://twitter.com/intent/tweet?url=<?php the_permalink(); ?>&text=<?php the_title(); ?>%20"><i class="caseicon-twitter"></i></a>
                <a class="pin-social" title="<?php echo esc_attr__('Pinterest', 'maxcare'); ?>" target="_blank" href="http://pinterest.com/pin/create/button/?url=<?php the_permalink(); ?>&media=<?php echo esc_url($img_url[0]); ?>&description=<?php the_title(); ?>%20"><i class="caseicon-pinterest"></i></a>
                <a class="lin-social" title="<?php echo esc_attr__('LinkedIn', 'maxcare'); ?>" target="_blank" href="http://www.linkedin.com/shareArticle?mini=true&url=<?php the_permalink(); ?>&title=<?php the_title(); ?>%20"><i class="caseicon-linkedin"></i></a>
            </div>
            <?php
        }

        public function get_post_nav() {
            global $post;
            $previous = ( is_attachment() ) ? get_post( $post->post_parent ) : get_adjacent_post( false, '', true );
            $next     = get_adjacent_post( false, '', false );

            if ( ! $next && ! $previous )
                return;
            ?>
            <?php
            $next_post = get_next_post();
            $previous_post = get_previous_post();

            if( !empty($next_post) || !empty($previous_post) ) { 
                $page_for_posts = get_option( 'page_for_posts' );
                ?>
                <div class="pxl-post--navigation">
                    <div class="pxl--items pxl-flex-middle">
                        <div class="pxl--item pxl--item-prev">
                            <?php if ( is_a( $previous_post , 'WP_Post' ) && get_the_title( $previous_post->ID ) != '') { 
                                $prev_img_id = get_post_thumbnail_id($previous_post->ID);
                                $prev_img_url = wp_get_attachment_image_src($prev_img_id, 'maxcare-thumb-xs');
                                ?>
                                <a class="pxl--label" href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>"><i class="caseicon-double-chevron-left"></i><span><?php echo esc_html__('Previous Post', 'maxcare'); ?></span></a>
                                <div class="pxl--holder">
                                    <?php if(!empty($prev_img_id)) : ?>
                                        <div class="pxl--img">
                                            <a  href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>"><img src="<?php echo wp_kses_post($prev_img_url[0]); ?>" /></a>
                                        </div>
                                    <?php endif; ?>
                                    <div class="pxl--meta">
                                        <a  href="<?php echo esc_url(get_permalink( $previous_post->ID )); ?>"><?php echo get_the_title( $previous_post->ID ); ?></a>
                                    </div>
                                </div>
                            <?php } ?>
                        </div>
                        <?php if ( get_option( 'page_for_posts' ) ) {
                            $post_id = get_option( 'page_for_posts' ); ?>
                            <div class="pxl-item-button">
                                <a href="<?php echo esc_url(get_permalink( $post_id )); ?>"><i class="flaticon-menu-2"></i></a>
                            </div>
                        <?php } ?>
                        <div class="pxl--item pxl--item-next">
                            <?php if ( is_a( $next_post , 'WP_Post' ) && get_the_title( $next_post->ID ) != '') {
                                $next_img_id = get_post_thumbnail_id($next_post->ID);
                                $next_img_url = wp_get_attachment_image_src($next_img_id, 'maxcare-thumb-xs');
                                ?>
                                <a class="pxl--label" href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>"><span><?php echo esc_html__('Next Post', 'maxcare'); ?></span><i class="caseicon-double-chevron-right"></i></a>
                                <div class="pxl--holder">
                                    <div class="pxl--meta">
                                        <a href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>"><?php echo get_the_title( $next_post->ID ); ?></a>
                                    </div>
                                    <?php if(!empty($next_img_id)) : ?>
                                        <div class="pxl--img">
                                            <a href="<?php echo esc_url(get_permalink( $next_post->ID )); ?>"><img src="<?php echo wp_kses_post($next_img_url[0]); ?>" /></a>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php } ?>
                        </div>
                    </div><!-- .nav-links -->
                </div>
            <?php }
        }

        public function get_post_author_info() { ?>
            <div class="pxl-post--author-info pxl-item--flexnw">
                <div class="pxl-post--author-image pxl-mr-30"><?php echo get_avatar( get_the_author_meta( 'ID' ), 280 ); ?></div>
                <div class="pxl-post--author-meta">
                    <?php maxcare_get_user_name(); ?>
                    <div class="pxl-post--author-description"><?php the_author_meta( 'description' ); ?></div>
                    <?php maxcare_get_user_social(); ?>
                </div>
            </div>
        <?php }

        public function get_related_post() {
            $post_related        = maxcare()->get_theme_opt('post_related', false);
            $post_related_title  = maxcare()->get_theme_opt('post_related_title');
            $post_date           = maxcare()->get_theme_opt('post_date', true);
            $post_category       = maxcare()->get_theme_opt('post_category', true);

            if (!$post_related) return;

            $post_number = 6;

            $query = new WP_Query([
                'posts_per_page'      => $post_number,
                'post_type'           => 'post',
                'post_status'         => 'publish',
                'post__not_in' => array(get_the_ID()),
                'ignore_sticky_posts' => true
            ]);



            if ($query->have_posts()) {
                $image_size = !empty($img_size) ? $img_size : '623x830';
                ?>
                <div class="pxl-related-post">
                    <div class="pxl-container-related">
                        <div class="pxl-row-related">
                            <div class="pxl-inner-item-related">
                                <div class="pxl-swiper-title">
                                    <h4 class="item-title wow fadeInUp" data-wow-delay="200ms" data-wow-duration="1.2s">
                                        <?php echo !empty($post_related_title) ? pxl_print_html($post_related_title) : esc_html__('Related posts', 'maxcare'); ?>
                                    </h4>

                                    <div class="pxl-item-slick-arrow">
                                        <div class="slick-prev slick-arrow" aria-label="Previous" style="">
                                            <svg width="24" height="16" viewBox="0 0 24 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                              <path d="M23 8H1M1 8L7 2M1 8L7 14" stroke="#121212" stroke-width="1.5" stroke-linecap="square" stroke-linejoin="round"/>
                                            </svg>
                                        </div>
                                        <div class="slick-next slick-arrow" aria-label="Next" style="">
                                            <svg width="24" height="16" viewBox="0 0 24 16" fill="none" xmlns="http://www.w3.org/2000/svg">
                                              <path d="M1 8H23M23 8L17 2M23 8L17 14" stroke="#121212" stroke-width="1.5" stroke-linecap="square" stroke-linejoin="round"/>
                                            </svg>
                                        </div>
                                    </div>
                                </div>

                                <div class="pxl-carousel-inner">
                                    <div class="pxl-related-post-inner wow fadeIn" data-wow-delay="300ms" data-wow-duration="1.2s">
                                        <?php while ($query->have_posts()) : $query->the_post(); ?>
                                            <div class="grid-item">
                                                <div class="pxl-grid-item-inner">
                                                    <?php if (has_post_thumbnail() && wp_get_attachment_image_src(get_post_thumbnail_id(), false)):
                                                        $img_id = get_post_thumbnail_id();
                                                        $img          = pxl_get_image_by_size( array(
                                                            'attach_id'  => $img_id,
                                                            'thumb_size' => $image_size
                                                        ) );
                                                        $thumbnail    = $img['thumbnail'];
                                                        ?>
                                                        <div class="pxl-item-featured">
                                                            <?php if ($post_date): ?>
                                                                <div class="item--date">
                                                                    <?php echo get_the_date('j M, Y'); ?>
                                                                </div>
                                                            <?php endif; ?>
                                                            <a class="pxl-img-link" href="<?php echo esc_url(get_permalink()); ?>"><?php echo wp_kses_post($thumbnail); ?></a>
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="pxl-item-content">
                                                        <?php if ($post_category): ?>
                                                            <div class="pxl-post--category">
                                                                <?php the_terms( get_the_ID(), 'category', '', ' ' ); ?>
                                                            </div>
                                                        <?php endif; ?>
                                                        <h6 class="pxl-item-title title-hover-line">
                                                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                                        </h6>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endwhile; ?>
                                    </div>
                                </div> 
                            </div>
                        </div>
                    </div>
                </div>
                <?php
                wp_reset_postdata();
            }
        }

    }
}
