<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
get_template_part( 'inc/admin/libs/tgmpa/class-tgm-plugin-activation' );

add_action( 'tgmpa_register', 'maxcare_register_required_plugins' );
function maxcare_register_required_plugins() {
    include( locate_template( 'inc/admin/demo-data/demo-config.php' ) );
    $pxl_server_info = apply_filters( 'pxl_server_info', ['plugin_url' => 'https://api.casethemes.net/plugins/'] ) ; 
    $default_path = $pxl_server_info['plugin_url'];  
    $images = get_template_directory_uri() . '/inc/admin/assets/img/plugins';
    $plugins = array(

        array(
            'name'               => esc_html__('Redux Framework', 'maxcare'),
            'slug'               => 'redux-framework',
            'required'           => true,
            'logo'        => $images . '/redux.png',
            'description' => esc_html__( 'Build theme options and post, page options for WordPress Theme.', 'maxcare' ),
        ),

        array(
            'name'        => esc_html__('Classic Editor', 'maxcare'),
            'slug'        => 'classic-editor',
            'required'    => true,
            'logo'        => $images . '/classic-editor.png',
            'description' => esc_html__('Classic Editor restores the previous WordPress editor and the Edit Post screen.', 'maxcare'),
        ),

        array(
            'name'               => esc_html__('Elementor', 'maxcare'),
            'slug'               => 'elementor',
            'required'           => true,
            'logo'        => $images . '/elementor.png',
            'description' => esc_html__( 'Introducing a WordPress website builder, with no limits of design. A website builder that delivers high-end page designs and advanced capabilities', 'maxcare' ),
        ),

        array(
            'name'               => esc_html__('Case Addons', 'maxcare'),
            'slug'               => 'case-addons',
            'source'             => 'case-addons.zip',
            'required'           => true,
            'logo'        => $images . '/case-addons.png',
            'description' => esc_html__( 'Main process and Powerful Elements Plugin, exclusively for maxcare WordPress Theme.', 'maxcare' ),
        ),
  
        array(
            'name'               => esc_html__('Contact Form 7', 'maxcare'),
            'slug'               => 'contact-form-7',
            'required'           => true,
            'logo'        => $images . '/contact-f7.png',
            'description' => esc_html__( 'Contact Form 7 can manage multiple contact forms, you can customize the form and the mail contents flexibly with simple markup', 'maxcare' ),
        ),

        array(
            'name'               => esc_html__('Mailchimp', 'maxcare'),
            'slug'               => "mailchimp-for-wp",
            'required'           => true,
            'logo'        => $images . '/mailchimp.png',
            'description' => esc_html__( 'Allowing your visitors to subscribe to your newsletter should be easy. With this plugin, it finally is.', 'maxcare' ),
        ),

        array(
            'name'        => esc_html__('One User Avatar', 'maxcare'),
            'slug'        => 'one-user-avatar',
            'required'    => true,
            'logo'        => $images . '/one-user-avatar.png',
            'description' => esc_html__('Allows users to upload custom avatars directly from their profile page.', 'maxcare'),
        ),
        
        array(
            'name'               => esc_html__('WooCommerce', 'maxcare'),
            'slug'               => "woocommerce",
            'required'           => true,
            'logo'        => $images . '/woo.png',
            'description' => esc_html__( 'WooCommerce is the world’s most popular open-source eCommerce solution.', 'maxcare' ),
        ),

        array(
            'name'               => esc_html__('WPC Smart Compare for WooCommerce', 'maxcare'),
            'slug'               => "woo-smart-compare",
            'required'           => true,
            'logo'        => $images . '/woo-smart-compare.png',
            'description' => esc_html__( 'WPC Smart Compare is a powerful solution that enhances user experience and boosts sales on your WooCommerce shop.', 'maxcare' ),
        ),

        array(
            'name'               => esc_html__('WPC Smart Wishlist for WooCommerce', 'maxcare'),
            'slug'               => "woo-smart-wishlist",
            'required'           => true,
            'logo'        => $images . '/woo-smart-wishlist.png',
            'description' => esc_html__( 'WPC Smart Wishlist helps customers save favorite items and manage their to-buy list with ease.', 'maxcare' ),
        ),

        array(
            'name'               => esc_html__('User Registration & Membership', 'maxcare'),
            'slug'               => "user-registration",
            'required'           => true,
            'logo'        => $images . '/user-RM.gif',
            'description' => esc_html__( 'User Registration & Membership lets you create custom forms, manage profiles, restrict content, and build membership sites easily.', 'maxcare' ),
        ),
    );
 

    $config = array(
        'default_path' => $default_path,           // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'is_automatic' => true,
    );

    tgmpa( $plugins, $config );

}