function closestEdge(x, y, w, h) {
    var topEdgeDist = distMetric(x, y, w / 2, 0);
    var bottomEdgeDist = distMetric(x, y, w / 2, h);
    var leftEdgeDist = distMetric(x, y, 0, h / 2);
    var rightEdgeDist = distMetric(x, y, w, h / 2);
    var min = Math.min(topEdgeDist, bottomEdgeDist, leftEdgeDist, rightEdgeDist);
    switch (min) {
        case leftEdgeDist: return "left";
        case rightEdgeDist: return "right";
        case topEdgeDist: return "top";
        case bottomEdgeDist: return "bottom";
    }
}

function distMetric(x, y, x2, y2) {
    var xDiff = x - x2;
    var yDiff = y - y2;
    return (xDiff * xDiff) + (yDiff * yDiff);
}

var boxes = document.querySelectorAll(".pxl-service-box1, .pxl-service-box2, .pxl-portfolio-grid-layout1 .pxl-post--inner");

boxes.forEach(function (box) {
    const overlay = box.querySelector('.pxl-hover-bg-boxes');

    box.addEventListener("mouseenter", function (e) {
        const rect = box.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        const edge = closestEdge(x, y, box.clientWidth, box.clientHeight);

        switch (edge) {
            case "left":
                overlay.style.top = "0%";
                overlay.style.left = "-100%";
                TweenMax.to(overlay, 0.5, { left: "0%" });
                break;
            case "right":
                overlay.style.top = "0%";
                overlay.style.left = "100%";
                TweenMax.to(overlay, 0.5, { left: "0%" });
                break;
            case "top":
                overlay.style.top = "-100%";
                overlay.style.left = "0%";
                TweenMax.to(overlay, 0.5, { top: "0%" });
                break;
            case "bottom":
                overlay.style.top = "100%";
                overlay.style.left = "0%";
                TweenMax.to(overlay, 0.5, { top: "0%" });
                break;
        }
    });

    box.addEventListener("mouseleave", function (e) {
        const rect = box.getBoundingClientRect();
        const x = e.clientX - rect.left;
        const y = e.clientY - rect.top;
        const edge = closestEdge(x, y, box.clientWidth, box.clientHeight);

        switch (edge) {
            case "left":
                TweenMax.to(overlay, 0.5, { left: "-100%" });
                break;
            case "right":
                TweenMax.to(overlay, 0.5, { left: "100%" });
                break;
            case "top":
                TweenMax.to(overlay, 0.5, { top: "-100%" });
                break;
            case "bottom":
                TweenMax.to(overlay, 0.5, { top: "100%" });
                break;
        }
    });
});
