( function( $ ) {
    "use strict";
    function maxcareElAfterRender(){
        let _elementor = typeof elementor != 'undefined' ? elementor : elementorFrontend;
        _elementor.hooks.addFilter('pxl_element_container/after-render', function(ouput, settings) {
            if(typeof settings.pxl_parallax_bg_img != 'undefined' && settings.pxl_parallax_bg_img.url != ''){
                ouput += '<div class="pxl-section-bg-parallax"></div>';
            }
            if (typeof settings.el_number_layer_overlay != 'undefined' && settings.el_number_layer_overlay == '1') {
                ouput += `<div class="e-con-overlay"></div>`;
            }    
            if (typeof settings.el_overlays != 'undefined' && settings.el_overlays.length > 0) {
                settings.el_overlays.forEach(function (item) {
                    let classes = 'e-con-overlay elementor-repeater-item-' + item._id;
                    ouput += `<div class="${classes}"></div>`;
                });
            }    
            return ouput;
        });
    }

    /*
    magnetic-2
    */
    if ($(".wa_magnetic_btn_2").length) {
        var waMagnets2 = document.querySelectorAll('.wa_magnetic_btn_2');
        var waStrength2 = 30;

        waMagnets2.forEach((magnet) => {
            magnet.addEventListener('mousemove', moveMagnet2);
            magnet.addEventListener('mouseout', function(event) {
                const innerElements = event.currentTarget.querySelectorAll('.wa_magnetic_btn_2_elm');
                innerElements.forEach((elm) => {
                    gsap.to(elm, {
                        x: 0,
                        y: 0,
                        duration: 1,
                        ease: "elastic.out(1, 0.3)"
                    });
                });
            });
        });

        function moveMagnet2(event) {
            var magnetButton = event.currentTarget;
            var bounding = magnetButton.getBoundingClientRect();
            const innerElements = magnetButton.querySelectorAll('.wa_magnetic_btn_2_elm');

            const xMove = (((event.clientX - bounding.left) / magnetButton.offsetWidth) - 0.5) * waStrength2;
            const yMove = (((event.clientY - bounding.top) / magnetButton.offsetHeight) - 0.5) * waStrength2;

            innerElements.forEach((elm) => {
                gsap.to(elm, {
                    x: xMove,
                    y: yMove,
                    duration: 1,
                    ease: "elastic.out(1, 0.3)"
                });
            });
        }
    }

    function maxcareElBeforeRender(){
        let _elementor = typeof elementor != 'undefined' ? elementor : elementorFrontend;
        
        _elementor.hooks.addFilter( 'pxl_element_container/before-render', function( ouput, settings) {
            return ouput;
        });
    } 

    var PXL_Icon_Contact_Form = function( $scope, $ ) {

        setTimeout(function () {
            $('.pxl--item').each(function () {
                var icon_input = $(this).find(".pxl--form-icon"),
                control_wrap = $(this).find('.wpcf7-form-control');
                control_wrap.before(icon_input.clone());
                icon_input.remove();
            });
        }, 10);

    };

    function maxcare_split_scroll_color() {
        gsap.registerPlugin(ScrollTrigger, SplitText);

        const revealContainers = document.querySelectorAll(".pxl-slip-text-color");

        revealContainers.forEach(container => {
            const split = new SplitText(container, { type: "words" });

            gsap.set(container, {
                perspective: 1000
            });

            gsap.fromTo(split.words,
                {
                    opacity: 0,
                    x: 30,
                    rotationX: 90,
                    transformOrigin: "center bottom",
                },
                {
                    opacity: 1,
                    x: 0,
                    rotationX: 0,
                    ease: "power4.out",
                    duration: 0.8,
                    stagger: {
                        each: 0.02,
                        from: "start"
                    },
                    scrollTrigger: {
                        start: "top 90%",
                        trigger: container,
                        toggleActions: "restart pause resume reverse",
                        scrub: false,
                    }
                }
            );
        });
    }

    function maxcare_triger_tabs_image($scope) {
        gsap.registerPlugin(ScrollTrigger);

        const $items = $scope.find('.pxl-tabs-slip.style-1 .pxl-item--content');
        const $inners_img = $scope.find('.pxl-tabs-slip.style-1 .pxl-item--content > .elementor');
        const $endTrigger_img = $scope.find('.pxl-tabs-slip.style-1 .pxl-tabs--content');

        if ($items.length > 0) {
            $items.each(function(index, item) {
                gsap.to(item, {
                    opacity: 1,
                    scrollTrigger: {
                        trigger: item,
                        start: "center top",
                        end: "bottom top",
                        scrub: true,
                    }
                });

                if (index < $items.length - 1) {
                    gsap.to(item, {
                        scrollTrigger: {
                            trigger: item,
                            start: "top top",
                            end: "bottom bottom+=150",
                            endTrigger: $endTrigger_img[0],
                            scrub: true,
                            pin: true,
                            pinSpacing: false,
                        }
                    });
                }
            });
        }

        $inners_img.each(function(index_m, inner_m) {
            if (index_m < $inners_img.length - 1) {
                gsap.to(inner_m, {
                    yPercent: 0,
                    scale: 1,
                    ease: "power2.out",
                    scrollTrigger: {
                        trigger: inner_m,
                        start: "top top",
                        end: "bottom top",
                        scrub: true,
                    }
                });
            }
        });
    }

    function maxcare_parallax_scale($scope) {
        setTimeout(function () {

            let revealContainers = document.querySelectorAll(".parallax-scale");

            revealContainers.forEach((container) => {
                let image = container.querySelector("img");
                let tb = gsap.timeline({
                    scrollTrigger: {
                        trigger: container,
                        toggleActions: "restart none none reset",
                        start: "top 95%",
                        end: "bottom 70%",
                        scrub: true,
                    }
                });

                gsap.set(container, { x: "0px", rotationY: "0" });
                gsap.set(image, { x: "0px", rotationY: "0" });

                tb.to(container, { 
                    x: "-21px", 
                    rotationY: "-27deg", 
                    ease: Power4.out,
                    duration: 1.5
                });
                tb.to(image, { 
                    x: "-21px", 
                    rotationY: "-27deg", 
                    ease: Power4.out,
                    duration: 1.5
                }, "-=1"); //

            });

        }, 100);
    }

    function maxcare_split_text($scope){

        setTimeout(function () {

            var st = $scope.find(".pxl-split-text");
            if(st.length == 0) return;
            gsap.registerPlugin(SplitText);
            st.each(function(index, el) {
                el.split = new SplitText(el, { 
                    type: "lines,words,chars",
                    linesClass: "split-line"
                });
                gsap.set(el, { perspective: 400 });

                if( $(el).hasClass('split-in-fade') ){
                    $(el).addClass('active');
                    gsap.set(el.split.chars, {
                        opacity: 0,
                        ease: "Back.easeOut",
                    });
                }
                if( $(el).hasClass('split-in-right') ){
                    gsap.set(el.split.chars, {
                        opacity: 0,
                        x: "50",
                        ease: "Back.easeOut",
                    });
                }
                if( $(el).hasClass('split-in-left') ){
                    gsap.set(el.split.chars, {
                        opacity: 0,
                        x: "-50",
                        ease: "circ.out",
                    });
                }
                if( $(el).hasClass('split-in-up') ){
                    gsap.set(el.split.chars, {
                        opacity: 0,
                        y: "80",
                        ease: "circ.out",
                    });
                }
                if( $(el).hasClass('split-in-down') ){
                    gsap.set(el.split.chars, {
                        opacity: 0,
                        y: "-80",
                        ease: "circ.out",
                    });
                }
                if( $(el).hasClass('split-in-rotate') ){
                    gsap.set(el.split.chars, {
                        opacity: 0,
                        rotateX: "50deg",
                        ease: "circ.out",
                    });
                }
                if( $(el).hasClass('split-in-scale') ){
                    gsap.set(el.split.chars, {
                        opacity: 0,
                        scale: "0.5",
                        ease: "circ.out",
                    });
                }
                el.anim = gsap.to(el.split.chars, {
                    scrollTrigger: {
                        trigger: el,
                        toggleActions: "restart pause resume reverse",
                        start: "top 90%",
                    },
                    x: "0",
                    y: "0",
                    rotateX: "0",
                    scale: 1,
                    opacity: 1,
                    duration: 0.8, 
                    stagger: 0.04,
                });
            });

        }, 200);
    }

    function maxcareWidgetTextImage($scope) {
        if($scope.find('.pxl-text-img-wrap').length <= 0) return;
        var mouseX = 0,
        mouseY = 0;

        $scope.find('.pxl-text-img-wrap .pxl-item--inner').mousemove(function(e){
            var offset = $(this).offset();
            mouseX = (e.pageX - offset.left);
            mouseY = (e.pageY - offset.top);
        });

        $scope.find('.pxl-text-img-wrap ul>li').on("mouseenter", function() {
            $(this).removeClass('deactive').addClass('active');
            var target = $(this).attr('data-target');
            $(this).closest('.pxl-item--inner').find(target).removeClass('deactive').addClass('active');
        });
        $scope.find('.pxl-text-img-wrap ul>li').on("mouseleave", function() {
            $(this).addClass('deactive').removeClass('active');
            var target = $(this).attr('data-target');
            $(this).closest('.pxl-item--inner').find(target).addClass('deactive').removeClass('active');
        });
        const s = {
            x: window.innerWidth / 2,
            y: window.innerHeight / 2
        },
        t = gsap.quickSetter($scope.find('.pxl-text-img-wrap .pxl-item--inner'), "css"),
        e = gsap.quickSetter($scope.find('.pxl-text-img-wrap .pxl-item--inner'), "css");

        gsap.ticker.add((() => {
            const o = .15,
            i = 1 - Math.pow(.85, gsap.ticker.deltaRatio());
            s.x += (mouseX - s.x) * i,
            s.y += (mouseY - s.y) * i,
            t({
                "--pxl-mouse-x": `${s.x}px`
            }), e({
                "--pxl-mouse-y": `${s.y}px`
            })
        }))
    }

    function maxcare_zoom_point(){
        elementorFrontend.waypoint($(document).find('.pxl-zoom-point'), function () {
            var offset = $(this).offset();
            var offset_top = offset.top;
            var scroll_top = $(window).scrollTop();
        }, {
            offset: -100,
            triggerOnce: true
        });
    }

    function maxcare_scroll_fixed_section(){
        if($('.pxl-section-fix-top').length > 0) {
            ScrollTrigger.matchMedia({
                "(min-width: 991px)": function() {
                    const pinnedSections = ['.pxl-section-fix-top'];
                    pinnedSections.forEach(className => {
                        gsap.to(".pxl-section-fix-bottom", {
                            scrollTrigger: {
                                trigger: ".pxl-section-fix-bottom",
                                scrub: true,
                                pin: className,
                                pinSpacing: false,
                                start: 'top bottom',
                                end: "bottom top",
                            },
                        });
                    });
                }
            });
        }
    }


    function maxcare_text_marquee($scope){

        const text_marquee = $scope.find('.pxl-text--marquee');

        const boxes = gsap.utils.toArray(text_marquee);

        const loop = text_horizontalLoop(boxes, {paused: false,repeat: -1,});

        function text_horizontalLoop(items, config) {
            items = gsap.utils.toArray(items);
            config = config || {};
            let tl = gsap.timeline({repeat: config.repeat, paused: config.paused, defaults: {ease: "none"}, onReverseComplete: () => tl.totalTime(tl.rawTime() + tl.duration() * 100)}),
            length = items.length,
            startX = items[0].offsetLeft,
            times = [],
            widths = [],
            xPercents = [],
            curIndex = 0,
            pixelsPerSecond = (config.speed || 1) * 100,
            snap = config.snap === false ? v => v : gsap.utils.snap(config.snap || 1),
            totalWidth, curX, distanceToStart, distanceToLoop, item, i;
            gsap.set(items, {
                xPercent: (i, el) => {
                    let w = widths[i] = parseFloat(gsap.getProperty(el, "width", "px"));
                    xPercents[i] = snap(parseFloat(gsap.getProperty(el, "x", "px")) / w * 100 + gsap.getProperty(el, "xPercent"));
                    return xPercents[i];
                }
            });
            gsap.set(items, {x: 0});
            totalWidth = items[length-1].offsetLeft + xPercents[length-1] / 100 * widths[length-1] - startX + items[length-1].offsetWidth * gsap.getProperty(items[length-1], "scaleX") + (parseFloat(config.paddingRight) || 0);
            for (i = 0; i < length; i++) {
                item = items[i];
                curX = xPercents[i] / 100 * widths[i];
                distanceToStart = item.offsetLeft + curX - startX;
                distanceToLoop = distanceToStart + widths[i] * gsap.getProperty(item, "scaleX");
                tl.to(item, {xPercent: snap((curX - distanceToLoop) / widths[i] * 100), duration: distanceToLoop / pixelsPerSecond}, 0)
                .fromTo(item, {xPercent: snap((curX - distanceToLoop + totalWidth) / widths[i] * 100)}, {xPercent: xPercents[i], duration: (curX - distanceToLoop + totalWidth - curX) / pixelsPerSecond, immediateRender: false}, distanceToLoop / pixelsPerSecond)
                .add("label" + i, distanceToStart / pixelsPerSecond);
                times[i] = distanceToStart / pixelsPerSecond;
            }
            function toIndex(index, vars) {
                vars = vars || {};
                (Math.abs(index - curIndex) > length / 2) && (index += index > curIndex ? -length : length);
                let newIndex = gsap.utils.wrap(0, length, index),
                time = times[newIndex];
                if (time > tl.time() !== index > curIndex) { 
                    vars.modifiers = {time: gsap.utils.wrap(0, tl.duration())};
                    time += tl.duration() * (index > curIndex ? 1 : -1);
                }
                curIndex = newIndex;
                vars.overwrite = true;
                return tl.tweenTo(time, vars);
            }
            tl.next = vars => toIndex(curIndex+1, vars);
            tl.previous = vars => toIndex(curIndex-1, vars);
            tl.current = () => curIndex;
            tl.toIndex = (index, vars) => toIndex(index, vars);
            tl.times = times;
            tl.progress(1, true).progress(0, true);
            if (config.reversed) {
                tl.vars.onReverseComplete();
                tl.reverse();
            }
            return tl;
        }
    }                             


    function maxcare_wheel_spin($scope) {
        const svg = document.getElementById("circle-svg");
        const existingPath = document.getElementById("circlePath");
        if (existingPath) existingPath.remove();

        const circlePath = MotionPathPlugin.convertToPath("#holder", false)[0];
        circlePath.id = "circlePath";
        svg.prepend(circlePath);

        const items = gsap.utils.toArray(".pxl-wheel-spin .pxl-item--list");
        const numItems = items.length;
        const itemStep = 1 / numItems;
        const wrapProgress = gsap.utils.wrap(0, 1);
        const snap = gsap.utils.snap(itemStep);
        const wrapTracker = gsap.utils.wrap(0, numItems);

        function getOffset() {
            return window.innerWidth <= 767 ? 0 : -0.05;
        }

        function applyMotionPath() {
            const offset = getOffset();
            gsap.set(items, {
                motionPath: {
                    path: circlePath,
                    align: circlePath,
                    alignOrigin: [0.5, 0.5],
                    end: i => (i / numItems + offset) % 1
                }
            });
        }

        applyMotionPath();

        items.forEach(item => item.classList.remove("active", "pre", "next"));
        items[0].classList.add("active");
        items[wrapTracker(0 - 1)].classList.add("pre");
        items[wrapTracker(0 + 1)].classList.add("next");

        const tracker = { item: 0 };

        const tl = gsap.timeline({ paused: true, reversed: true });

        tl.to(".pxl-wheel-spin .pxl-item--inner", {
            rotation: 360,
            transformOrigin: "center",
            duration: 1,
            ease: "none"
        });

        tl.to(items, {
            rotation: "-=360",
            transformOrigin: "center",
            duration: 1,
            ease: "none"
        }, 0);

        tl.to(tracker, {
            item: numItems,
            duration: 1,
            ease: "none",
            modifiers: {
                item(value) {
                    return wrapTracker(numItems - Math.round(value));
                }
            }
        }, 0);

        items.forEach((el, i) => {
            el.addEventListener("click", () => {
                let current = tracker.item;
                if (i === current) return;

                items.forEach(item => {
                    item.classList.remove("active", "pre", "next");
                });

                el.classList.add("active");
                items[wrapTracker(i - 1)].classList.add("pre");
                items[wrapTracker(i + 1)].classList.add("next");

                let diff = current - i;

                if (Math.abs(diff) < numItems / 2) {
                    moveWheel(diff * itemStep);
                } else {
                    let amt = numItems - Math.abs(diff);
                    moveWheel(current > i ? amt * -itemStep : amt * itemStep);
                }
            });
        });

        function moveWheel(amount) {
            gsap.to(tl, {
                progress: snap(tl.progress() + amount),
                modifiers: {
                    progress: wrapProgress
                }
            });
        }
    }





    $( window ).on( 'elementor/frontend/init', function() {
        maxcareElAfterRender();
        maxcareElBeforeRender();
        maxcare_zoom_point();
        maxcare_scroll_fixed_section();
        maxcare_parallax_scale();
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_contact_form.default', PXL_Icon_Contact_Form );
        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_heading.default', function( $scope ) {
            maxcare_split_text($scope);
            maxcare_split_scroll_color($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_text_editor.default', function( $scope ) {
            maxcare_split_scroll_color($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_process_cards.default', function( $scope ) {
            maxcare_split_text($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_product_categories_carousel.default', function( $scope ) {
            maxcare_split_text($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_tabs_slip.default', function( $scope ) {
            if ($(window).width() > 767) {
                maxcare_triger_tabs_image($scope);
            }
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_text_marquee.default', function( $scope ) {
            maxcare_text_marquee($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_commitment.default', function( $scope ) {
            maxcare_split_text($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_image_marquee.default', function( $scope ) {
            maxcare_split_text($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_product_grid.default', function( $scope ) {
            maxcare_split_text($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_post_carousel.default', function( $scope ) {
            maxcare_split_text($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_image_carousel.default', function( $scope ) {
            maxcare_split_text($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_testimonial_marquee.default', function( $scope ) {
            maxcare_split_text($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_wheel_spin.default', function( $scope ) { 
            maxcare_wheel_spin($scope);
        } );

        elementorFrontend.hooks.addAction( 'frontend/element_ready/pxl_list_box.default', function( $scope ) {
            maxcareWidgetTextImage($scope);
        } );

    } );

} )( jQuery );