<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link_text', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link_text', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link_text', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-service-box pxl-service-box2">
	<div class="pxl-item-inner">
        <div class="pxl-hover-bg-boxes" style="background-image: url(<?php echo esc_attr($settings['bg_image']['url']); ?>);"></div>
		<div class="pxl-meta-content <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
            <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                <div class="pxl-item--icon">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <div class="pxl-item--icon">
                    <?php $img_icon  = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                    echo pxl_print_html($thumbnail_icon); ?>
                </div>
            <?php endif; ?>
            <div class="pxl-item-title">
                <?php echo esc_attr($settings['title']); ?>
            </div>
            <div class="pxl-item-desc">
                <?php echo esc_attr($settings['desc']); ?>
            </div>
            <div class="pxl-sevice--btn">
                <a class="pxl-item-btn" <?php pxl_print_html($widget->get_render_attribute_string( 'link_text' )); ?>>
                    <span class="pxl-btn-title pxl--btn-text">
                        <?php echo esc_attr($settings['title_btn'])?>
                    </span>
                    <span class="pxl-icon-button">
                        <svg width="35" height="35" viewBox="0 0 35 35" fill="none" xmlns="http://www.w3.org/2000/svg">
                          <path d="M10.3906 17.2927H23.6299" stroke="#03045E" stroke-width="1.25425"/>
                          <path d="M19.4492 12.415L24.3268 17.2927L19.4492 22.1704" stroke="#03045E" stroke-width="1.25425" stroke-linejoin="round"/>
                        </svg>
                    </span>
                </a>
            </div>
		</div>
	</div>
</div>