<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link_text', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link_text', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link_text', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-meta-box pxl-meta-box3">
	<div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <div class="pxl-inner-top">
            <h5 class="pxl-item-heading">
                <?php echo esc_attr($settings['heading']); ?>
            </h5>
            <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                <div class="pxl-item--icon">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <div class="pxl-item--icon">
                    <?php $img_icon  = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                    echo pxl_print_html($thumbnail_icon); ?>
                </div>
            <?php endif; ?>
        </div>
        <?php if(isset($settings['meta_box_list']) && !empty($settings['meta_box_list']) && count($settings['meta_box_list'])): ?>
            <div class="pxl-box-list">
                <?php foreach ($settings['meta_box_list'] as $key => $value):
                    ?>
                    <div class="pxl-item">
                        <?php if(!empty($value['title_list'])): ?>
                            <span class="pxl-title-list">
                                <?php echo pxl_print_html($value['title_list'])?>
                            </span>
                        <?php endif; ?>

                        <?php if(!empty($value['time_list'])): ?>
                            <span class="pxl-item-time">
                                <?php echo pxl_print_html($value['time_list'])?>
                            </span>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
        <div class="pxl-content-btn">
            <a class="pxl-item-btn" <?php pxl_print_html($widget->get_render_attribute_string( 'link_text' )); ?>>
                <span class="pxl-btn-text">
                    <?php echo esc_attr($settings['btn_text'])?>
                </span>
                <span class="pxl-btn-icon">
                    <svg width="22" height="20" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <g clip-path="url(#clip0_2067_880)">
                        <path d="M20.6909 9.92188L20.73 9.29688H20.7104C20.7104 9.29688 20.7039 9.29688 20.6909 9.29688C20.6779 9.29688 20.6649 9.29688 20.6519 9.29688C20.6128 9.28385 20.5705 9.27409 20.5249 9.26758C20.4793 9.26107 20.4305 9.2513 20.3784 9.23828C20.2612 9.21224 20.1213 9.17969 19.9585 9.14062C19.7957 9.10156 19.6102 9.04948 19.4019 8.98438C19.0112 8.86719 18.575 8.70768 18.0933 8.50586C17.6115 8.30404 17.1362 8.04688 16.6675 7.73438C16.2378 7.44792 15.8504 7.08333 15.5054 6.64062C15.1603 6.19792 14.8706 5.75521 14.6362 5.3125C14.519 5.09115 14.4149 4.88607 14.3237 4.69727C14.2326 4.50846 14.161 4.34245 14.1089 4.19922C14.0828 4.12109 14.0568 4.05599 14.0308 4.00391C14.0047 3.95182 13.9852 3.90625 13.9722 3.86719C13.9722 3.84115 13.9689 3.82161 13.9624 3.80859C13.9559 3.79557 13.9461 3.78255 13.9331 3.76953V3.75C13.9331 3.75 13.9071 3.75977 13.855 3.7793C13.8029 3.79883 13.6336 3.85417 13.3472 3.94531C13.0477 4.04948 12.8719 4.10807 12.8198 4.12109C12.7677 4.13411 12.7417 4.14062 12.7417 4.14062L12.7612 4.17969C12.7612 4.19271 12.7645 4.20898 12.771 4.22852C12.7775 4.24805 12.7873 4.27083 12.8003 4.29688C12.8133 4.33594 12.8328 4.38802 12.8589 4.45312C12.8849 4.51823 12.9175 4.58984 12.9565 4.66797C13.0216 4.82422 13.103 5.00977 13.2007 5.22461C13.2983 5.43945 13.4123 5.66406 13.5425 5.89844C13.8029 6.38021 14.1349 6.88802 14.5386 7.42188C14.9422 7.95573 15.424 8.41146 15.9839 8.78906C16.1271 8.88021 16.2703 8.9681 16.4136 9.05273C16.5568 9.13737 16.7 9.21875 16.8433 9.29688H0.72998V10.5469H16.8433C16.7 10.625 16.5568 10.7064 16.4136 10.791C16.2703 10.8757 16.1271 10.9635 15.9839 11.0547C15.424 11.4323 14.9422 11.888 14.5386 12.4219C14.1349 12.9557 13.8029 13.4635 13.5425 13.9453C13.4123 14.1797 13.2983 14.401 13.2007 14.6094C13.103 14.8177 13.0216 15.0065 12.9565 15.1758C12.9175 15.2539 12.8849 15.3255 12.8589 15.3906C12.8328 15.4557 12.8133 15.5078 12.8003 15.5469C12.7873 15.5729 12.7775 15.5957 12.771 15.6152C12.7645 15.6348 12.7612 15.6445 12.7612 15.6445L12.7417 15.6836V15.7031C12.7417 15.7031 12.7677 15.7096 12.8198 15.7227C12.8719 15.7357 13.0477 15.7943 13.3472 15.8984C13.6336 15.9896 13.8029 16.0449 13.855 16.0645C13.9071 16.084 13.9331 16.0938 13.9331 16.0938V16.0742C13.9461 16.0612 13.9559 16.0482 13.9624 16.0352C13.9689 16.0221 13.9722 16.0026 13.9722 15.9766C13.9852 15.9375 14.0047 15.8919 14.0308 15.8398C14.0568 15.7878 14.0828 15.7227 14.1089 15.6445C14.161 15.5013 14.2326 15.3353 14.3237 15.1465C14.4149 14.9577 14.519 14.7526 14.6362 14.5312C14.8706 14.0885 15.1603 13.6458 15.5054 13.2031C15.8504 12.7604 16.2378 12.3958 16.6675 12.1094C17.1362 11.7969 17.6115 11.5397 18.0933 11.3379C18.575 11.1361 19.0112 10.9766 19.4019 10.8594C19.6102 10.7943 19.7957 10.7422 19.9585 10.7031C20.1213 10.6641 20.2612 10.6315 20.3784 10.6055C20.4305 10.5924 20.4793 10.5827 20.5249 10.5762C20.5705 10.5697 20.6128 10.5599 20.6519 10.5469C20.6649 10.5469 20.6779 10.5469 20.6909 10.5469C20.7039 10.5469 20.7104 10.5469 20.7104 10.5469H20.73L20.6909 9.92188Z" fill="#000"/>
                      </g>
                      <defs>
                        <clipPath id="clip0_2067_880">
                          <rect width="21" height="20" fill="white" transform="matrix(1 0 0 -1 0.22998 20)"/>
                        </clipPath>
                      </defs>
                    </svg>
                </span>
            </a>
        </div>
	</div>
</div>