<?php
$html_id = pxl_get_element_id($settings);
if ( ! empty( $settings['link']['url'] ) ) {
    $widget->add_render_attribute( 'link_text', 'href', $settings['link']['url'] );

    if ( $settings['link']['is_external'] ) {
        $widget->add_render_attribute( 'link_text', 'target', '_blank' );
    }

    if ( $settings['link']['nofollow'] ) {
        $widget->add_render_attribute( 'link_text', 'rel', 'nofollow' );
    }
}
?>
<div class="pxl-meta-box pxl-meta-box1">
    <div class="pxl-item-inner <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <div class="pxl-inner-top">
            <h5 class="pxl-item-heading">
                <?php echo esc_attr($settings['heading']); ?>
            </h5>
            <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                <div class="pxl-item--icon">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </div>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <div class="pxl-item--icon">
                    <?php $img_icon  = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                    echo pxl_print_html($thumbnail_icon); ?>
                </div>
            <?php endif; ?>
        </div>
        <div class="pxl-item-desc">
            <?php echo esc_attr($settings['desc']); ?>
        </div>
        <div class="pxl-meta-content">
            <div class="pxl-title-svg">
                <div class="pxl-itemsvg">
                    <svg width="21" height="21" viewBox="0 0 21 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <path d="M12.8616 8.48677V5.36177C12.8616 5.19601 12.9274 5.03704 13.0446 4.91983C13.1618 4.80262 13.3208 4.73677 13.4866 4.73677C13.6523 4.73677 13.8113 4.80262 13.9285 4.91983C14.0457 5.03704 14.1116 5.19601 14.1116 5.36177V6.97818L16.7944 4.29458C16.9117 4.17731 17.0707 4.11142 17.2366 4.11142C17.4024 4.11142 17.5615 4.17731 17.6788 4.29458C17.796 4.41186 17.8619 4.57092 17.8619 4.73677C17.8619 4.90262 17.796 5.06168 17.6788 5.17896L14.996 7.86177H16.6116C16.7773 7.86177 16.9363 7.92762 17.0535 8.04483C17.1707 8.16204 17.2366 8.32101 17.2366 8.48677C17.2366 8.65253 17.1707 8.8115 17.0535 8.92871C16.9363 9.04592 16.7773 9.11177 16.6116 9.11177H13.4866C13.3208 9.11177 13.1618 9.04592 13.0446 8.92871C12.9274 8.8115 12.8616 8.65253 12.8616 8.48677ZM19.1022 14.6649C18.9629 15.7235 18.443 16.6952 17.6396 17.3985C16.8363 18.1019 15.8043 18.4887 14.7366 18.4868C8.53346 18.4868 3.48658 13.4399 3.48658 7.23677C3.48452 6.16907 3.87132 5.13715 4.57468 4.33387C5.27804 3.53058 6.24984 3.01089 7.30846 2.87193C7.57606 2.83918 7.84708 2.89383 8.08109 3.02773C8.31509 3.16163 8.49953 3.36759 8.60689 3.6149L10.2569 7.29849V7.30787C10.339 7.49728 10.3729 7.70408 10.3556 7.9098C10.3383 8.11552 10.2703 8.31374 10.1577 8.48677C10.1436 8.50786 10.1288 8.5274 10.1131 8.54693L8.48658 10.4751C9.07174 11.6641 10.3155 12.8969 11.5202 13.4836L13.4217 11.8657C13.4404 11.85 13.46 11.8354 13.4803 11.8219C13.6532 11.7066 13.8521 11.6362 14.0591 11.6171C14.266 11.598 14.4744 11.6308 14.6655 11.7126L14.6756 11.7172L18.3561 13.3665C18.604 13.4733 18.8106 13.6575 18.9451 13.8916C19.0796 14.1256 19.1347 14.3969 19.1022 14.6649ZM17.8616 14.5086C17.8616 14.5086 17.8561 14.5086 17.853 14.5086L14.1811 12.8641L12.2788 14.4821C12.2605 14.498 12.2412 14.5126 12.221 14.5258C12.0411 14.6458 11.8331 14.7171 11.6175 14.7327C11.4018 14.7484 11.1858 14.7077 10.9905 14.6149C9.52721 13.9079 8.06861 12.4602 7.3608 11.0126C7.26707 10.8187 7.22501 10.6039 7.2387 10.389C7.25239 10.1741 7.32136 9.96639 7.43892 9.78599C7.45218 9.76481 7.46707 9.74469 7.48346 9.72583L9.11158 7.79536L7.47096 4.12349C7.47065 4.12037 7.47065 4.11723 7.47096 4.11411C6.71334 4.21294 6.01774 4.58455 5.5144 5.15936C5.01107 5.73417 4.73453 6.47274 4.73658 7.23677C4.73948 9.88805 5.79397 12.4299 7.66871 14.3046C9.54345 16.1794 12.0853 17.2339 14.7366 17.2368C15.5001 17.2394 16.2385 16.9638 16.8137 16.4616C17.3888 15.9593 17.7613 15.2648 17.8616 14.5079V14.5086Z" fill="#000"/>
                    </svg>
                </div>  
                <h6 class="pxl-item-title">
                    <?php echo esc_attr($settings['title']); ?>
                </h6>
            </div>
            <div class="pxl-item-text">
                <span><?php echo esc_html($settings['text1']); ?></span>
                <span><?php echo esc_html($settings['text2']); ?></span>
            </div>
        </div>
        <div class="pxl-content-btn">
            <a class="pxl-item-btn" <?php pxl_print_html($widget->get_render_attribute_string( 'link_text' )); ?>>
                <span class="pxl-btn-text">
                    <?php echo esc_attr($settings['btn_text'])?>
                </span>
                <span class="pxl-btn-icon">
                    <svg width="22" height="20" viewBox="0 0 22 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                      <g clip-path="url(#clip0_2067_880)">
                        <path d="M20.6909 9.92188L20.73 9.29688H20.7104C20.7104 9.29688 20.7039 9.29688 20.6909 9.29688C20.6779 9.29688 20.6649 9.29688 20.6519 9.29688C20.6128 9.28385 20.5705 9.27409 20.5249 9.26758C20.4793 9.26107 20.4305 9.2513 20.3784 9.23828C20.2612 9.21224 20.1213 9.17969 19.9585 9.14062C19.7957 9.10156 19.6102 9.04948 19.4019 8.98438C19.0112 8.86719 18.575 8.70768 18.0933 8.50586C17.6115 8.30404 17.1362 8.04688 16.6675 7.73438C16.2378 7.44792 15.8504 7.08333 15.5054 6.64062C15.1603 6.19792 14.8706 5.75521 14.6362 5.3125C14.519 5.09115 14.4149 4.88607 14.3237 4.69727C14.2326 4.50846 14.161 4.34245 14.1089 4.19922C14.0828 4.12109 14.0568 4.05599 14.0308 4.00391C14.0047 3.95182 13.9852 3.90625 13.9722 3.86719C13.9722 3.84115 13.9689 3.82161 13.9624 3.80859C13.9559 3.79557 13.9461 3.78255 13.9331 3.76953V3.75C13.9331 3.75 13.9071 3.75977 13.855 3.7793C13.8029 3.79883 13.6336 3.85417 13.3472 3.94531C13.0477 4.04948 12.8719 4.10807 12.8198 4.12109C12.7677 4.13411 12.7417 4.14062 12.7417 4.14062L12.7612 4.17969C12.7612 4.19271 12.7645 4.20898 12.771 4.22852C12.7775 4.24805 12.7873 4.27083 12.8003 4.29688C12.8133 4.33594 12.8328 4.38802 12.8589 4.45312C12.8849 4.51823 12.9175 4.58984 12.9565 4.66797C13.0216 4.82422 13.103 5.00977 13.2007 5.22461C13.2983 5.43945 13.4123 5.66406 13.5425 5.89844C13.8029 6.38021 14.1349 6.88802 14.5386 7.42188C14.9422 7.95573 15.424 8.41146 15.9839 8.78906C16.1271 8.88021 16.2703 8.9681 16.4136 9.05273C16.5568 9.13737 16.7 9.21875 16.8433 9.29688H0.72998V10.5469H16.8433C16.7 10.625 16.5568 10.7064 16.4136 10.791C16.2703 10.8757 16.1271 10.9635 15.9839 11.0547C15.424 11.4323 14.9422 11.888 14.5386 12.4219C14.1349 12.9557 13.8029 13.4635 13.5425 13.9453C13.4123 14.1797 13.2983 14.401 13.2007 14.6094C13.103 14.8177 13.0216 15.0065 12.9565 15.1758C12.9175 15.2539 12.8849 15.3255 12.8589 15.3906C12.8328 15.4557 12.8133 15.5078 12.8003 15.5469C12.7873 15.5729 12.7775 15.5957 12.771 15.6152C12.7645 15.6348 12.7612 15.6445 12.7612 15.6445L12.7417 15.6836V15.7031C12.7417 15.7031 12.7677 15.7096 12.8198 15.7227C12.8719 15.7357 13.0477 15.7943 13.3472 15.8984C13.6336 15.9896 13.8029 16.0449 13.855 16.0645C13.9071 16.084 13.9331 16.0938 13.9331 16.0938V16.0742C13.9461 16.0612 13.9559 16.0482 13.9624 16.0352C13.9689 16.0221 13.9722 16.0026 13.9722 15.9766C13.9852 15.9375 14.0047 15.8919 14.0308 15.8398C14.0568 15.7878 14.0828 15.7227 14.1089 15.6445C14.161 15.5013 14.2326 15.3353 14.3237 15.1465C14.4149 14.9577 14.519 14.7526 14.6362 14.5312C14.8706 14.0885 15.1603 13.6458 15.5054 13.2031C15.8504 12.7604 16.2378 12.3958 16.6675 12.1094C17.1362 11.7969 17.6115 11.5397 18.0933 11.3379C18.575 11.1361 19.0112 10.9766 19.4019 10.8594C19.6102 10.7943 19.7957 10.7422 19.9585 10.7031C20.1213 10.6641 20.2612 10.6315 20.3784 10.6055C20.4305 10.5924 20.4793 10.5827 20.5249 10.5762C20.5705 10.5697 20.6128 10.5599 20.6519 10.5469C20.6649 10.5469 20.6779 10.5469 20.6909 10.5469C20.7039 10.5469 20.7104 10.5469 20.7104 10.5469H20.73L20.6909 9.92188Z" fill="#000"/>
                      </g>
                      <defs>
                        <clipPath id="clip0_2067_880">
                          <rect width="21" height="20" fill="white" transform="matrix(1 0 0 -1 0.22998 20)"/>
                        </clipPath>
                      </defs>
                    </svg>
                </span>
            </a>
        </div>
    </div>
</div>