<?php
$pagination = $widget->get_setting('pagination', false);
?>
<?php if(isset($settings['hero_list']) && !empty($settings['hero_list']) && count($settings['hero_list'])):
$image_size = !empty($settings['img_size']) ? $settings['img_size'] : 'full';  ?>
    <div class="pxl-carousel-hero pxl-carousel-hero1 <?php echo esc_attr($settings['style']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms" data-duration="<?php echo esc_attr( $settings['image_duration'] ); ?>">
        <div class="pxl-item-inner">
            <?php foreach ($settings['hero_list'] as $key => $value):
                $image = isset($value['image']) ? $value['image'] : '';
                $image_lv2 = isset($value['image_lv2']) ? $value['image_lv2'] : '';
                $image_overlay = isset($value['image_overlay']) ? $value['image_overlay'] : '';
                $title = isset($value['title']) ? $value['title'] : '';
                $desc = isset($value['desc']) ? $value['desc'] : '';
                $title_btn = isset($value['title_btn']) ? $value['title_btn'] : '';
                $link_key = $widget->get_repeater_setting_key( 'item_link', 'value', $key );
                if ( ! empty( $value['item_link']['url'] ) ) {
                    $widget->add_render_attribute( $link_key, 'href', $value['item_link']['url'] );

                    if ( $value['item_link']['is_external'] ) {
                        $widget->add_render_attribute( $link_key, 'target', '_blank' );
                    }

                    if ( $value['item_link']['nofollow'] ) {
                        $widget->add_render_attribute( $link_key, 'rel', 'nofollow' );
                    }
                }
                $link_attributes = $widget->get_render_attribute_string( $link_key ); ?>
                <div class="pxl-item">
                    <div class="pxl-bg-hero" style="background-image: url(<?php echo esc_attr($value['image']['url']); ?>);"></div>
                    <div class="pxl-bg-overlay" style="background-image: url(<?php echo esc_attr($value['image_overlay']['url']); ?>);"></div>
                    <div class="pxl-item-content">
                        <?php if(!empty($image_lv2['id'])) { 
                            $img = pxl_get_image_by_size( array(
                                'attach_id'  => $image_lv2['id'],
                                'thumb_size' => $image_size,
                                'class' => 'no-lazyload',
                            ));
                            $thumbnail = $img['thumbnail'];
                            ?>
                            <div class="pxl-item--img">
                                <?php echo wp_kses_post($thumbnail); ?>
                            </div>
                        <?php } ?>
                        <div class="pxl-content-slide">
                            <div class="pxl-item-left">
                                <h1 class="pxl-item--title">
                                    <?php echo pxl_print_html($title); ?>
                                </h1>
                                <div class="pxl-item--desc"><?php echo pxl_print_html($desc); ?></div>
                            </div>
                            <div class="pxl-item-btn">
                                <a class="btn pxl-icon-active  btn-default  pxl-icon--right" <?php echo implode( ' ', [ $link_attributes ] ); ?>>
                                    <span class="pxl-btn-icon">
                                        <svg xmlns="http://www.w3.org/2000/svg" class="pxl-icon-arrow-right" width="24" height="24" viewBox="0 0 24 24" fill="none"><path d="M13 5L20 12M20 12L13 19M20 12H4" stroke="#03045E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path></svg>
                                    </span>
                                    <span class="pxl--btn-text"><?php echo pxl_print_html($title_btn); ?></span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>
            <?php if($pagination !== false): ?>
                <div class="pxl-swiper-dots style-1"></div>
            <?php endif; ?>
        </div>
    </div>
<?php endif; ?>