<?php 
if ( ! empty( $settings['button_link']['url'] ) ) {
    $widget->add_render_attribute( 'button_link', 'href', $settings['button_link']['url'] );

    if ( $settings['button_link']['is_external'] ) {
        $widget->add_render_attribute( 'button_link', 'target', '_blank' );
    }

    if ( $settings['button_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button_link', 'rel', 'nofollow' );
    }
}
$html_id = pxl_get_element_id($settings);
$style = isset($settings['style']) ? $settings['style'] : '';
?>
<div class="pxl-button-custom pxl-button-custom1 <?php echo esc_attr($settings['style']); ?>">
    <div class="pxl-item--inner <?php echo esc_attr($settings['btn_action']); ?> <?php echo esc_attr($settings['pxl_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['pxl_animate_delay']); ?>ms">
        <?php if ( ! empty( $settings['button_link']['url'] ) ) { ?><a class="btn-cutom btn" <?php pxl_print_html($widget->get_render_attribute_string( 'button_link' )); ?> data-onepage-offset="<?php echo esc_attr($settings['onepage_offset']); ?>"><?php } ?>
            <?php if ( $settings['icon_type'] == 'icon' && !empty($settings['pxl_icon']['value']) ) : ?>
                <span class="pxl-item--icon">
                    <?php \Elementor\Icons_Manager::render_icon( $settings['pxl_icon'], [ 'aria-hidden' => 'true', 'class' => '' ], 'i' ); ?>
                </span>
            <?php endif; ?>
            <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
                <span class="pxl-item--icon">
                    <?php $img_icon  = pxl_get_image_by_size( array(
                            'attach_id'  => $settings['icon_image']['id'],
                            'thumb_size' => 'full',
                        ) );
                        $thumbnail_icon    = $img_icon['thumbnail'];
                    echo pxl_print_html($thumbnail_icon); ?>
                </span>
            <?php endif; ?>
            <span class="pxl-btn-title"><?php echo esc_html($settings['title_btn']); ?></span>
        <?php if ( ! empty( $settings['button_link']['url'] ) ) { ?></a><?php } ?>
    </div>
</div>